/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.tilemap;

import com.work4games.handlers.Content;
import com.work4games.tilemap.Tile;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TileMap {
    private double startX;
    private double startY;
    private int[][] map;
    private int tileSize;
    private String mapName;
    private int timeLimit;
    private int numRows;
    private int numCols;
    private int width;
    private int height;
    private Tile[][] tiles;

    public TileMap(int tileSize) {
        this.tileSize = tileSize;
    }

    public void loadMap(String s) {
        try {
            System.out.println(s);
            InputStream in = this.getClass().getResourceAsStream(s);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            this.mapName = br.readLine();
            this.timeLimit = Integer.parseInt(br.readLine());
            this.numRows = Integer.parseInt(br.readLine());
            this.numCols = Integer.parseInt(br.readLine());
            this.tiles = new Tile[this.numRows][this.numCols];
            this.map = new int[this.numRows][this.numCols];
            this.width = this.numCols * this.tileSize;
            this.height = this.numRows * this.tileSize;
            this.startX = (640 - this.width) / 2;
            this.startY = (480 - this.height) / 2 + 40;
            String delims = "\\s+";
            int row = 0;
            while (row < this.numRows) {
                String line = br.readLine();
                String[] tokens = line.split(delims);
                int col = 0;
                while (col < this.numCols) {
                    this.map[row][col] = Integer.parseInt(tokens[col]);
                    if (this.map[row][col] == 1) {
                        this.tiles[row][col] = new Tile(Content.NormalTile, 1, row, col);
                    } else if (this.map[row][col] == 2) {
                        this.tiles[row][col] = new Tile(Content.NormalTile, 1, row, col);
                        this.tiles[row][col].setSpawner(true);
                    } else if (this.map[row][col] == 3) {
                        this.tiles[row][col] = new Tile(Content.GreyedTile, 3, row, col);
                    } else if (this.map[row][col] == 4) {
                        this.tiles[row][col] = new Tile(Content.GreyedTile, 3, row, col);
                        this.tiles[row][col].setLocked(true);
                    } else if (this.map[row][col] == 0) {
                        this.tiles[row][col] = new Tile(null, 0, row, col);
                    }
                    ++col;
                }
                ++row;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                double x = this.startX + (double)(col * this.tileSize);
                double y = this.startY + (double)(row * this.tileSize);
                this.tiles[row][col].setX((int)x);
                this.tiles[row][col].setY((int)y);
                ++col;
            }
            ++row;
        }
    }

    public void draw(Graphics2D g) {
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                double x = this.startX + (double)(col * this.tileSize);
                double y = this.startY + (double)(row * this.tileSize);
                if (this.tiles[row][col].getState() != 0) {
                    g.drawImage((Image)this.tiles[row][col].getImage(), (int)x, (int)y, null);
                }
                this.tiles[row][col].setX((int)x);
                this.tiles[row][col].setY((int)y);
                g.setColor(Color.white);
                if (row == 0 && this.tiles[row][col].getState() == 1) {
                    g.fillRect((int)x - 2, (int)y - 2, this.tileSize + 4, 2);
                }
                if (row != 0 && this.tiles[row - 1][col].getState() == 0 && this.tiles[row][col].getState() == 1) {
                    g.fillRect((int)x, (int)y - 2, this.tileSize, 2);
                }
                if (row == this.numRows - 1 && this.tiles[row][col].getState() == 1) {
                    g.fillRect((int)x - 2, (int)y + this.tileSize, this.tileSize + 4, 2);
                }
                if (row != this.numRows - 1 && this.tiles[row + 1][col].getState() == 0 && this.tiles[row][col].getState() == 1) {
                    g.fillRect((int)x, (int)y + this.tileSize, this.tileSize, 2);
                }
                if (col == this.numCols - 1 && this.tiles[row][col].getState() == 1) {
                    g.fillRect((int)x + this.tileSize, (int)y - 2, 2, this.tileSize + 4);
                }
                if (col != this.numCols - 1 && this.tiles[row][col + 1].getState() == 0 && this.tiles[row][col].getState() == 1) {
                    g.fillRect((int)x + this.tileSize, (int)y, 2, this.tileSize);
                }
                if (col == 0 && this.tiles[row][col].getState() == 1) {
                    g.fillRect((int)x - 2, (int)y - 2, 2, this.tileSize + 4);
                }
                if (col != 0 && this.tiles[row][col - 1].getState() == 0 && this.tiles[row][col].getState() == 1) {
                    g.fillRect((int)x - 2, (int)y, 2, this.tileSize);
                }
                ++col;
            }
            ++row;
        }
    }

    public void convert(int r, int c) {
        this.tiles[r][c].changeState(1);
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getTileState(int r, int c) {
        return this.tiles[r][c].getState();
    }

    public boolean getTileSpawn(int r, int c) {
        return this.tiles[r][c].getSpawner();
    }

    public boolean getTileLocked(int r, int c) {
        return this.tiles[r][c].getLocked();
    }

    public void setTileLocked(int r, int c, boolean b) {
        this.tiles[r][c].setLocked(b);
    }

    public int getTileX(int r, int c) {
        return this.tiles[r][c].getX();
    }

    public int getTileY(int r, int c) {
        return this.tiles[r][c].getY();
    }

    public double getStartX() {
        return this.startX;
    }

    public double getStartY() {
        return this.startY;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public void addStartX(double x) {
        this.startX += x;
    }

    public void addStartY(double y) {
        this.startY += y;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public String getMapName() {
        return this.mapName;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }
}

